---
layout: default
title: arm resource scans
nav_order: 1
---

# arm resource scans (auto generated)

|     | Id            | Type      | Entity                                                                       | Policy                                                                                                            | IaC   | Resource Link                                                                                                                                                                                                |
|-----|---------------|-----------|------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|-------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|   0 | CKV_AZURE_1   | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Azure Instance does not use basic authentication(Use SSH Key Instead)                                      | arm   | [AzureInstancePassword.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureInstancePassword.py)                                                                           |
|   1 | CKV_AZURE_2   | resource  | Microsoft.Compute/disks                                                      | Ensure Azure managed disk have encryption enabled                                                                 | arm   | [AzureManagedDiscEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureManagedDiscEncryption.py)                                                                 |
|   2 | CKV_AZURE_3   | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that 'supportsHttpsTrafficOnly' is set to 'true'                                                           | arm   | [StorageAccountsTransportEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountsTransportEncryption.py)                                                 |
|   3 | CKV_AZURE_4   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS logging to Azure Monitoring is Configured                                                              | arm   | [AKSLoggingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSLoggingEnabled.py)                                                                                   |
|   4 | CKV_AZURE_5   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure RBAC is enabled on AKS clusters                                                                            | arm   | [AKSRbacEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSRbacEnabled.py)                                                                                         |
|   5 | CKV_AZURE_6   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS has an API Server Authorized IP Ranges enabled                                                         | arm   | [AKSApiServerAuthorizedIpRanges.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSApiServerAuthorizedIpRanges.py)                                                         |
|   6 | CKV_AZURE_7   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS cluster has Network Policy configured                                                                  | arm   | [AKSNetworkPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSNetworkPolicy.py)                                                                                     |
|   7 | CKV_AZURE_8   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Kubernetes Dashboard is disabled                                                                           | arm   | [AKSDashboardDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSDashboardDisabled.py)                                                                             |
|   8 | CKV_AZURE_9   | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that RDP access is restricted from the internet                                                            | arm   | [NSGRuleRDPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleRDPAccessRestricted.py)                                                                 |
|   9 | CKV_AZURE_9   | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that RDP access is restricted from the internet                                                            | arm   | [NSGRuleRDPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleRDPAccessRestricted.py)                                                                 |
|  10 | CKV_AZURE_10  | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that SSH access is restricted from the internet                                                            | arm   | [NSGRuleSSHAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleSSHAccessRestricted.py)                                                                 |
|  11 | CKV_AZURE_10  | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that SSH access is restricted from the internet                                                            | arm   | [NSGRuleSSHAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleSSHAccessRestricted.py)                                                                 |
|  12 | CKV_AZURE_11  | resource  | Microsoft.Sql/servers                                                        | Ensure no SQL Databases allow ingress from 0.0.0.0/0 (ANY IP)                                                     | arm   | [SQLServerNoPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerNoPublicAccess.py)                                                                       |
|  13 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/FlowLogs                                   | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | arm   | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  14 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/FlowLogs/                                  | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | arm   | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  15 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/flowLogs                                   | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | arm   | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  16 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/flowLogs/                                  | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | arm   | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  17 | CKV_AZURE_13  | resource  | Microsoft.Web/sites/config                                                   | Ensure App Service Authentication is set on Azure App Service                                                     | arm   | [AppServiceAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceAuthentication.py)                                                                     |
|  18 | CKV_AZURE_13  | resource  | config                                                                       | Ensure App Service Authentication is set on Azure App Service                                                     | arm   | [AppServiceAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceAuthentication.py)                                                                     |
|  19 | CKV_AZURE_14  | resource  | Microsoft.Web/sites                                                          | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service                                           | arm   | [AppServiceHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHTTPSOnly.py)                                                                               |
|  20 | CKV_AZURE_15  | resource  | Microsoft.Web/sites                                                          | Ensure web app is using the latest version of TLS encryption                                                      | arm   | [AppServiceMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceMinTLSVersion.py)                                                                       |
|  21 | CKV_AZURE_16  | resource  | Microsoft.Web/sites                                                          | Ensure that Register with Azure Active Directory is enabled on App Service                                        | arm   | [AppServiceIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceIdentity.py)                                                                                 |
|  22 | CKV_AZURE_17  | resource  | Microsoft.Web/sites                                                          | Ensure the web app has 'Client Certificates (Incoming client certificates)' set                                   | arm   | [AppServiceClientCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceClientCertificate.py)                                                               |
|  23 | CKV_AZURE_18  | resource  | Microsoft.Web/sites                                                          | Ensure that 'HTTP Version' is the latest if used to run the web app                                               | arm   | [AppServiceHttps20Enabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHttps20Enabled.py)                                                                     |
|  24 | CKV_AZURE_19  | resource  | Microsoft.Security/pricings                                                  | Ensure that standard pricing tier is selected                                                                     | arm   | [SecurityCenterStandardPricing.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterStandardPricing.py)                                                           |
|  25 | CKV_AZURE_20  | resource  | Microsoft.Security/securityContacts                                          | Ensure that security contact 'Phone number' is set                                                                | arm   | [SecurityCenterContactPhone.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactPhone.py)                                                                 |
|  26 | CKV_AZURE_21  | resource  | Microsoft.Security/securityContacts                                          | Ensure that 'Send email notification for high severity alerts' is set to 'On'                                     | arm   | [SecurityCenterContactEmailAlert.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactEmailAlert.py)                                                       |
|  27 | CKV_AZURE_22  | resource  | Microsoft.Security/securityContacts                                          | Ensure that 'Send email notification for high severity alerts' is set to 'On'                                     | arm   | [SecurityCenterContactEmailAlertAdmins.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactEmailAlertAdmins.py)                                           |
|  28 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers                                                        | Ensure that 'Auditing' is set to 'Enabled' for SQL servers                                                        | arm   | [SQLServerAuditingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerAuditingEnabled.py)                                                                     |
|  29 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Auditing' is set to 'Enabled' for SQL servers                                                        | arm   | [SQLServerAuditingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerAuditingEnabled.py)                                                                     |
|  30 | CKV_AZURE_24  | resource  | Microsoft.Sql/servers                                                        | Ensure that 'Auditing' Retention is 'greater than 90 days' for SQL servers                                        | arm   | [SQLServerAuditingRetention90Days.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerAuditingRetention90Days.py)                                                     |
|  31 | CKV_AZURE_25  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Threat Detection types' is set to 'All'                                                              | arm   | [SQLServerThreatDetectionTypes.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerThreatDetectionTypes.py)                                                           |
|  32 | CKV_AZURE_26  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Send Alerts To' is enabled for MSSQL servers                                                         | arm   | [SQLServerEmailAlertsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerEmailAlertsEnabled.py)                                                               |
|  33 | CKV_AZURE_27  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Email service and co-administrators' is 'Enabled' for MSSQL servers                                  | arm   | [SQLServerEmailAlertsToAdminsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerEmailAlertsToAdminsEnabled.py)                                               |
|  34 | CKV_AZURE_28  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure 'Enforce SSL connection' is set to 'ENABLED' for MySQL Database Server                                     | arm   | [MySQLServerSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLServerSSLEnforcementEnabled.py)                                                     |
|  35 | CKV_AZURE_29  | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure 'Enforce SSL connection' is set to 'ENABLED' for PostgreSQL Database Server                                | arm   | [PostgreSQLServerSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerSSLEnforcementEnabled.py)                                           |
|  36 | CKV_AZURE_30  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure server parameter 'log_checkpoints' is set to 'ON' for PostgreSQL Database Server                           | arm   | [PostgreSQLServerLogCheckpointsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogCheckpointsEnabled.py)                                           |
|  37 | CKV_AZURE_30  | resource  | configurations                                                               | Ensure server parameter 'log_checkpoints' is set to 'ON' for PostgreSQL Database Server                           | arm   | [PostgreSQLServerLogCheckpointsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogCheckpointsEnabled.py)                                           |
|  38 | CKV_AZURE_31  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure configuration 'log_connections' is set to 'ON' for PostgreSQL Database Server                              | arm   | [PostgreSQLServerLogConnectionsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogConnectionsEnabled.py)                                           |
|  39 | CKV_AZURE_31  | resource  | configurations                                                               | Ensure configuration 'log_connections' is set to 'ON' for PostgreSQL Database Server                              | arm   | [PostgreSQLServerLogConnectionsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogConnectionsEnabled.py)                                           |
|  40 | CKV_AZURE_32  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure server parameter 'connection_throttling' is set to 'ON' for PostgreSQL Database Server                     | arm   | [PostgreSQLServerConnectionThrottlingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerConnectionThrottlingEnabled.py)                               |
|  41 | CKV_AZURE_32  | resource  | configurations                                                               | Ensure server parameter 'connection_throttling' is set to 'ON' for PostgreSQL Database Server                     | arm   | [PostgreSQLServerConnectionThrottlingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerConnectionThrottlingEnabled.py)                               |
|  42 | CKV_AZURE_33  | resource  | Microsoft.Storage/storageAccounts/queueServices/providers/diagnosticsettings | Ensure Storage logging is enabled for Queue service for read, write and delete requests                           | arm   | [StorageAccountLoggingQueueServiceEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountLoggingQueueServiceEnabled.py)                                     |
|  43 | CKV_AZURE_34  | resource  | Microsoft.Storage/storageAccounts/blobServices/containers                    | Ensure that 'Public access level' is set to Private for blob containers                                           | arm   | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  44 | CKV_AZURE_34  | resource  | blobServices/containers                                                      | Ensure that 'Public access level' is set to Private for blob containers                                           | arm   | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  45 | CKV_AZURE_34  | resource  | containers                                                                   | Ensure that 'Public access level' is set to Private for blob containers                                           | arm   | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  46 | CKV_AZURE_35  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure default network access rule for Storage Accounts is set to deny                                            | arm   | [StorageAccountDefaultNetworkAccessDeny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountDefaultNetworkAccessDeny.py)                                         |
|  47 | CKV_AZURE_36  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure 'Trusted Microsoft Services' is enabled for Storage Account access                                         | arm   | [StorageAccountAzureServicesAccessEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountAzureServicesAccessEnabled.py)                                     |
|  48 | CKV_AZURE_37  | resource  | Microsoft.Insights/logprofiles                                               | Ensure that Activity Log Retention is set 365 days or greater                                                     | arm   | [MonitorLogProfileRetentionDays.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MonitorLogProfileRetentionDays.py)                                                         |
|  49 | CKV_AZURE_38  | resource  | Microsoft.Insights/logprofiles                                               | Ensure audit profile captures all the activities                                                                  | arm   | [MonitorLogProfileCategories.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MonitorLogProfileCategories.py)                                                               |
|  50 | CKV_AZURE_39  | resource  | Microsoft.Authorization/roleDefinitions                                      | Ensure that no custom subscription owner roles are created                                                        | arm   | [CustomRoleDefinitionSubscriptionOwner.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CustomRoleDefinitionSubscriptionOwner.py)                                           |
|  51 | CKV_AZURE_40  | resource  | Microsoft.KeyVault/vaults/keys                                               | Ensure that the expiration date is set on all keys                                                                | arm   | [KeyExpirationDate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyExpirationDate.py)                                                                                   |
|  52 | CKV_AZURE_41  | resource  | Microsoft.KeyVault/vaults/secrets                                            | Ensure that the expiration date is set on all secrets                                                             | arm   | [SecretExpirationDate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecretExpirationDate.py)                                                                             |
|  53 | CKV_AZURE_42  | resource  | Microsoft.KeyVault/vaults                                                    | Ensure the key vault is recoverable                                                                               | arm   | [KeyvaultRecoveryEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyvaultRecoveryEnabled.py)                                                                       |
|  54 | CKV_AZURE_43  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure Storage Accounts adhere to the naming rules                                                                | arm   | [StorageAccountName.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountName.py)                                                                                 |
|  55 | CKV_AZURE_44  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure Storage Account is using the latest version of TLS encryption                                              | arm   | [StorageAccountMinimumTlsVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountMinimumTlsVersion.py)                                                       |
|  56 | CKV_AZURE_45  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that no sensitive credentials are exposed in VM custom_data                                                | arm   | [VMCredsInCustomData.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMCredsInCustomData.py)                                                                               |
|  57 | CKV_AZURE_47  | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure 'Enforce SSL connection' is set to 'ENABLED' for MariaDB servers                                           | arm   | [MariaDBSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBSSLEnforcementEnabled.py)                                                             |
|  58 | CKV_AZURE_48  | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure 'public network access enabled' is set to 'False' for MariaDB servers                                      | arm   | [MariaDBPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBPublicAccessDisabled.py)                                                               |
|  59 | CKV_AZURE_49  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure Azure linux scale set does not use basic authentication(Use SSH Key Instead)                               | arm   | [AzureScaleSetPassword.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureScaleSetPassword.py)                                                                           |
|  60 | CKV_AZURE_50  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Virtual Machine Extensions are not Installed                                                               | arm   | [AzureInstanceExtensions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureInstanceExtensions.py)                                                                       |
|  61 | CKV_AZURE_52  | resource  | Microsoft.Sql/servers                                                        | Ensure MSSQL is using the latest version of TLS encryption                                                        | arm   | [MSSQLServerMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MSSQLServerMinTLSVersion.py)                                                                     |
|  62 | CKV_AZURE_53  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure 'public network access enabled' is set to 'False' for mySQL servers                                        | arm   | [MySQLPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLPublicAccessDisabled.py)                                                                   |
|  63 | CKV_AZURE_53  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure 'public network access enabled' is set to 'False' for mySQL servers                                        | arm   | [MySQLPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLPublicAccessDisabled.py)                                                                   |
|  64 | CKV_AZURE_54  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure MySQL is using the latest version of TLS encryption                                                        | arm   | [MySQLServerMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLServerMinTLSVersion.py)                                                                     |
|  65 | CKV_AZURE_56  | resource  | Microsoft.Web/sites/config                                                   | Ensure that function apps enables Authentication                                                                  | arm   | [FunctionAppsEnableAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsEnableAuthentication.py)                                                     |
|  66 | CKV_AZURE_57  | resource  | Microsoft.Web/sites                                                          | Ensure that CORS disallows every resource to access app services                                                  | arm   | [AppServiceDisallowCORS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDisallowCORS.py)                                                                         |
|  67 | CKV_AZURE_58  | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Azure Synapse workspaces enables managed virtual networks                                             | arm   | [SynapseWorkspaceEnablesManagedVirtualNetworks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceEnablesManagedVirtualNetworks.py)                           |
|  68 | CKV_AZURE_59  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that Storage accounts disallow public access                                                               | arm   | [StorageAccountDisablePublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountDisablePublicAccess.py)                                                   |
|  69 | CKV_AZURE_62  | resource  | Microsoft.Web/sites                                                          | Ensure function apps are not accessible from all regions                                                          | arm   | [FunctionAppDisallowCORS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppDisallowCORS.py)                                                                       |
|  70 | CKV_AZURE_63  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables HTTP logging                                                                      | arm   | [AppServiceHttpLoggingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHttpLoggingEnabled.py)                                                             |
|  71 | CKV_AZURE_64  | resource  | Microsoft.StorageSync/storageSyncServices                                    | Ensure that Azure File Sync disables public network access                                                        | arm   | [StorageSyncPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageSyncPublicAccessDisabled.py)                                                       |
|  72 | CKV_AZURE_65  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables detailed error messages                                                           | arm   | [AppServiceDetailedErrorMessagesEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDetailedErrorMessagesEnabled.py)                                         |
|  73 | CKV_AZURE_66  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables failed request tracing                                                            | arm   | [AppServiceEnableFailedRequest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceEnableFailedRequest.py)                                                           |
|  74 | CKV_AZURE_67  | resource  | Microsoft.Web/sites                                                          | Ensure that 'HTTP Version' is the latest, if used to run the Function app                                         | arm   | [FunctionAppHttpVersionLatest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppHttpVersionLatest.py)                                                             |
|  75 | CKV_AZURE_67  | resource  | Microsoft.Web/sites/slots                                                    | Ensure that 'HTTP Version' is the latest, if used to run the Function app                                         | arm   | [FunctionAppHttpVersionLatest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppHttpVersionLatest.py)                                                             |
|  76 | CKV_AZURE_68  | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server disables public network access                                                      | arm   | [PostgreSQLServerPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerPublicAccessDisabled.py)                                             |
|  77 | CKV_AZURE_70  | resource  | Microsoft.Web/sites                                                          | Ensure that Function apps is only accessible over HTTPS                                                           | arm   | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  78 | CKV_AZURE_70  | resource  | Microsoft.Web/sites/config                                                   | Ensure that Function apps is only accessible over HTTPS                                                           | arm   | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  79 | CKV_AZURE_70  | resource  | Microsoft.Web/sites/slots                                                    | Ensure that Function apps is only accessible over HTTPS                                                           | arm   | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  80 | CKV_AZURE_71  | resource  | Microsoft.Web/sites                                                          | Ensure that Managed identity provider is enabled for web apps                                                     | arm   | [AppServiceIdentityProviderEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceIdentityProviderEnabled.py)                                                   |
|  81 | CKV_AZURE_72  | resource  | Microsoft.Web/sites                                                          | Ensure that remote debugging is not enabled for app services                                                      | arm   | [AppServiceRemoteDebuggingNotEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceRemoteDebuggingNotEnabled.py)                                               |
|  82 | CKV_AZURE_73  | resource  | Microsoft.Automation/automationAccounts/variables                            | Ensure that Automation account variables are encrypted                                                            | arm   | [AutomationEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AutomationEncrypted.py)                                                                               |
|  83 | CKV_AZURE_74  | resource  | Microsoft.Kusto/clusters                                                     | Ensure that Azure Data Explorer (Kusto) uses disk encryption                                                      | arm   | [DataExplorerUsesDiskEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataExplorerUsesDiskEncryption.py)                                                         |
|  84 | CKV_AZURE_75  | resource  | Microsoft.Kusto/clusters                                                     | Ensure that Azure Data Explorer uses double encryption                                                            | arm   | [AzureDataExplorerDoubleEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDataExplorerDoubleEncryptionEnabled.py)                                     |
|  85 | CKV_AZURE_76  | resource  | Microsoft.Batch/batchAccounts                                                | Ensure that Azure Batch account uses key vault to encrypt data                                                    | arm   | [AzureBatchAccountUsesKeyVaultEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureBatchAccountUsesKeyVaultEncryption.py)                                       |
|  86 | CKV_AZURE_78  | resource  | Microsoft.Web/sites                                                          | Ensure FTP deployments are disabled                                                                               | arm   | [AppServiceFTPSState.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceFTPSState.py)                                                                               |
|  87 | CKV_AZURE_79  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for SQL servers on machines                                               | arm   | [AzureDefenderOnSqlServersVMS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnSqlServersVMS.py)                                                             |
|  88 | CKV_AZURE_80  | resource  | Microsoft.Web/sites/config                                                   | Ensure that 'Net Framework' version is the latest, if used as a part of the web app                               | arm   | [AppServiceDotnetFrameworkVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDotnetFrameworkVersion.py)                                                     |
|  89 | CKV_AZURE_81  | resource  | Microsoft.Web/sites                                                          | Ensure that 'PHP version' is the latest, if used to run the web app                                               | arm   | [AppServicePHPVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePHPVersion.py)                                                                             |
|  90 | CKV_AZURE_82  | resource  | Microsoft.Web/sites                                                          | Ensure that 'Python version' is the latest, if used to run the web app                                            | arm   | [AppServicePythonVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePythonVersion.py)                                                                       |
|  91 | CKV_AZURE_83  | resource  | Microsoft.Web/sites                                                          | Ensure that 'Java version' is the latest, if used to run the web app                                              | arm   | [AppServiceJavaVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceJavaVersion.py)                                                                           |
|  92 | CKV_AZURE_84  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Storage                                                               | arm   | [AzureDefenderOnStorage.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnStorage.py)                                                                         |
|  93 | CKV_AZURE_85  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Kubernetes                                                            | arm   | [AzureDefenderOnKubernetes.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnKubernetes.py)                                                                   |
|  94 | CKV_AZURE_87  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Key Vault                                                             | arm   | [AzureDefenderOnKeyVaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnKeyVaults.py)                                                                     |
|  95 | CKV_AZURE_88  | resource  | Microsoft.Web/sites/config                                                   | Ensure that app services use Azure Files                                                                          | arm   | [AppServiceUsedAzureFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceUsedAzureFiles.py)                                                                     |
|  96 | CKV_AZURE_89  | resource  | Microsoft.Cache/redis                                                        | Ensure that Azure Cache for Redis disables public network access                                                  | arm   | [RedisCachePublicNetworkAccessEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/RedisCachePublicNetworkAccessEnabled.py)                                             |
|  97 | CKV_AZURE_92  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual Machines use managed disks                                                                    | arm   | [VMStorageOsDisk.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMStorageOsDisk.py)                                                                                       |
|  98 | CKV_AZURE_93  | resource  | Microsoft.Compute/disks                                                      | Ensure that managed disks use a specific set of disk encryption sets for the customer-managed key encryption      | arm   | [AzureManagedDiskEncryptionSet.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureManagedDiskEncryptionSet.py)                                                           |
|  99 | CKV_AZURE_94  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure that My SQL server enables geo-redundant backups                                                           | arm   | [MySQLGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLGeoBackupEnabled.py)                                                                           |
| 100 | CKV_AZURE_95  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that automatic OS image patching is enabled for Virtual Machine Scale Sets                                 | arm   | [VMScaleSetsAutoOSImagePatchingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMScaleSetsAutoOSImagePatchingEnabled.py)                                           |
| 101 | CKV_AZURE_96  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure that MySQL server enables infrastructure encryption                                                        | arm   | [MySQLEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLEncryptionEnabled.py)                                                                         |
| 102 | CKV_AZURE_97  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that Virtual machine scale sets have encryption at host enabled                                            | arm   | [VMEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMEncryptionAtHostEnabled.py)                                                                   |
| 103 | CKV_AZURE_97  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual machine scale sets have encryption at host enabled                                            | arm   | [VMEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMEncryptionAtHostEnabled.py)                                                                   |
| 104 | CKV_AZURE_99  | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure Cosmos DB accounts have restricted access                                                                  | arm   | [CosmosDBAccountsRestrictedAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBAccountsRestrictedAccess.py)                                                     |
| 105 | CKV_AZURE_100 | resource  | Microsoft.DocumentDb/databaseAccounts                                        | Ensure that Cosmos DB accounts have customer-managed keys to encrypt data at rest                                 | arm   | [CosmosDBHaveCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBHaveCMK.py)                                                                                       |
| 106 | CKV_AZURE_101 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure that Azure Cosmos DB disables public network access                                                        | arm   | [CosmosDBDisablesPublicNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBDisablesPublicNetwork.py)                                                           |
| 107 | CKV_AZURE_102 | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server enables geo-redundant backups                                                       | arm   | [PostgressSQLGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgressSQLGeoBackupEnabled.py)                                                             |
| 108 | CKV_AZURE_103 | resource  | Microsoft.DataFactory/factories                                              | Ensure that Azure Data Factory uses Git repository for source control                                             | arm   | [DataFactoryUsesGitRepository.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataFactoryUsesGitRepository.py)                                                             |
| 109 | CKV_AZURE_104 | resource  | Microsoft.DataFactory/factories                                              | Ensure that Azure Data factory public network access is disabled                                                  | arm   | [DataFactoryNoPublicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataFactoryNoPublicNetworkAccess.py)                                                     |
| 110 | CKV_AZURE_105 | resource  | Microsoft.DataLakeStore/accounts                                             | Ensure that Data Lake Store accounts enables encryption                                                           | arm   | [DataLakeStoreEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataLakeStoreEncryption.py)                                                                       |
| 111 | CKV_AZURE_107 | resource  | Microsoft.ApiManagement/service                                              | Ensure that API management services use virtual networks                                                          | arm   | [APIServicesUseVirtualNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIServicesUseVirtualNetwork.py)                                                             |
| 112 | CKV_AZURE_109 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault allows firewall rules settings                                                              | arm   | [KeyVaultEnablesFirewallRulesSettings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesFirewallRulesSettings.py)                                             |
| 113 | CKV_AZURE_110 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault enables purge protection                                                                    | arm   | [KeyVaultEnablesPurgeProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesPurgeProtection.py)                                                         |
| 114 | CKV_AZURE_111 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault enables soft delete                                                                         | arm   | [KeyVaultEnablesSoftDelete.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesSoftDelete.py)                                                                   |
| 115 | CKV_AZURE_112 | resource  | Microsoft.KeyVault/vaults/keys                                               | Ensure that key vault key is backed by HSM                                                                        | arm   | [KeyBackedByHSM.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyBackedByHSM.py)                                                                                         |
| 116 | CKV_AZURE_113 | resource  | Microsoft.Sql/servers                                                        | Ensure that SQL server disables public network access                                                             | arm   | [SQLServerHasPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerHasPublicAccessDisabled.py)                                                     |
| 117 | CKV_AZURE_114 | resource  | Microsoft.KeyVault/vaults/secrets                                            | Ensure that key vault secrets have "content_type" set                                                             | arm   | [SecretContentType.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecretContentType.py)                                                                                   |
| 118 | CKV_AZURE_121 | resource  | Microsoft.Network/frontDoors                                                 | Ensure that Azure Front Door enables WAF                                                                          | arm   | [AzureFrontDoorEnablesWAF.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureFrontDoorEnablesWAF.py)                                                                     |
| 119 | CKV_AZURE_123 | resource  | Microsoft.Network/FrontDoorWebApplicationFirewallPolicies                    | Ensure that Azure Front Door uses WAF in "Detection" or "Prevention" modes                                        | arm   | [FrontdoorUseWAFMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FrontdoorUseWAFMode.py)                                                                               |
| 120 | CKV_AZURE_125 | resource  | Microsoft.ServiceFabric/clusters                                             | Ensures that Service Fabric use three levels of protection available                                              | arm   | [AzureServiceFabricClusterProtectionLevel.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureServiceFabricClusterProtectionLevel.py)                                     |
| 121 | CKV_AZURE_129 | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure that MariaDB server enables geo-redundant backups                                                          | arm   | [MariaDBGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBGeoBackupEnabled.py)                                                                       |
| 122 | CKV_AZURE_130 | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server enables infrastructure encryption                                                   | arm   | [PostgreSQLEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLEncryptionEnabled.py)                                                               |
| 123 | CKV_AZURE_131 | parameter | secureString                                                                 | SecureString parameter should not have hardcoded default values                                                   | arm   | [SecureStringParameterNoHardcodedValue.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/parameter/SecureStringParameterNoHardcodedValue.py)                                          |
| 124 | CKV_AZURE_132 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure cosmosdb does not allow privileged escalation by restricting management plane changes                      | arm   | [CosmosDBDisableAccessKeyWrite.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBDisableAccessKeyWrite.py)                                                           |
| 125 | CKV_AZURE_133 | resource  | Microsoft.Network/frontdoorWebApplicationFirewallPolicies                    | Ensure Front Door WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell                        | arm   | [FrontDoorWAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FrontDoorWAFACLCVE202144228.py)                                                               |
| 126 | CKV_AZURE_134 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that Cognitive Services accounts disable public network access                                             | arm   | [CognitiveServicesDisablesPublicNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesDisablesPublicNetwork.py)                                         |
| 127 | CKV_AZURE_135 | resource  | Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies           | Ensure Application Gateway WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell               | arm   | [AppGatewayWAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppGatewayWAFACLCVE202144228.py)                                                             |
| 128 | CKV_AZURE_137 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure ACR admin account is disabled                                                                              | arm   | [ACRAdminAccountDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRAdminAccountDisabled.py)                                                                       |
| 129 | CKV_AZURE_138 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensures that ACR disables anonymous pulling of images                                                             | arm   | [ACRAnonymousPullDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRAnonymousPullDisabled.py)                                                                     |
| 130 | CKV_AZURE_139 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure ACR set to disable public networking                                                                       | arm   | [ACRPublicNetworkAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRPublicNetworkAccessDisabled.py)                                                         |
| 131 | CKV_AZURE_140 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure that Local Authentication is disabled on CosmosDB                                                          | arm   | [CosmosDBLocalAuthDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBLocalAuthDisabled.py)                                                                   |
| 132 | CKV_AZURE_141 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS local admin account is disabled                                                                        | arm   | [AKSLocalAdminDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSLocalAdminDisabled.py)                                                                           |
| 133 | CKV_AZURE_145 | resource  | Microsoft.Web/sites                                                          | Ensure Function app is using the latest version of TLS encryption                                                 | arm   | [FunctionAppMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppMinTLSVersion.py)                                                                     |
| 134 | CKV_AZURE_145 | resource  | Microsoft.Web/sites/slots                                                    | Ensure Function app is using the latest version of TLS encryption                                                 | arm   | [FunctionAppMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppMinTLSVersion.py)                                                                     |
| 135 | CKV_AZURE_149 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that Virtual machine does not enable password authentication                                               | arm   | [VMDisablePasswordAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMDisablePasswordAuthentication.py)                                                       |
| 136 | CKV_AZURE_149 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual machine does not enable password authentication                                               | arm   | [VMDisablePasswordAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMDisablePasswordAuthentication.py)                                                       |
| 137 | CKV_AZURE_151 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Windows VM enables encryption                                                                              | arm   | [WinVMEncryptionAtHost.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMEncryptionAtHost.py)                                                                           |
| 138 | CKV_AZURE_153 | resource  | Microsoft.Web/sites                                                          | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service Slot                                      | arm   | [AppServiceSlotHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotHTTPSOnly.py)                                                                       |
| 139 | CKV_AZURE_153 | resource  | Microsoft.Web/sites/slots                                                    | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service Slot                                      | arm   | [AppServiceSlotHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotHTTPSOnly.py)                                                                       |
| 140 | CKV_AZURE_155 | resource  | Microsoft.Web/sites                                                          | Ensure debugging is disabled for the App service slot                                                             | arm   | [AppServiceSlotDebugDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotDebugDisabled.py)                                                               |
| 141 | CKV_AZURE_155 | resource  | Microsoft.Web/sites/slots                                                    | Ensure debugging is disabled for the App service slot                                                             | arm   | [AppServiceSlotDebugDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotDebugDisabled.py)                                                               |
| 142 | CKV_AZURE_157 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Synapse workspace has data_exfiltration_protection_enabled                                            | arm   | [SynapseWorkspaceEnablesDataExfilProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceEnablesDataExfilProtection.py)                                 |
| 143 | CKV_AZURE_158 | resource  | Microsoft.Databricks/workspaces                                              | Ensure Databricks Workspace data plane to control plane communication happens over private link                   | arm   | [DatabricksWorkspaceIsNotPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DatabricksWorkspaceIsNotPublic.py)                                                         |
| 144 | CKV_AZURE_160 | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that HTTP (port 80) access is restricted from the internet                                                 | arm   | [NSGRuleHTTPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleHTTPAccessRestricted.py)                                                               |
| 145 | CKV_AZURE_160 | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that HTTP (port 80) access is restricted from the internet                                                 | arm   | [NSGRuleHTTPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleHTTPAccessRestricted.py)                                                               |
| 146 | CKV_AZURE_163 | resource  | Microsoft.ContainerRegistry/registries                                       | Enable vulnerability scanning for container images.                                                               | arm   | [ACRContainerScanEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRContainerScanEnabled.py)                                                                       |
| 147 | CKV_AZURE_166 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure container image quarantine, scan, and mark images verified                                                 | arm   | [ACREnableImageQuarantine.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableImageQuarantine.py)                                                                     |
| 148 | CKV_AZURE_168 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Azure Kubernetes Cluster (AKS) nodes should use a minimum number of 50 pods.                               | arm   | [AKSMaxPodsMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSMaxPodsMinimum.py)                                                                                   |
| 149 | CKV_AZURE_168 | resource  | Microsoft.ContainerService/managedClusters/agentPools                        | Ensure Azure Kubernetes Cluster (AKS) nodes should use a minimum number of 50 pods.                               | arm   | [AKSMaxPodsMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSMaxPodsMinimum.py)                                                                                   |
| 150 | CKV_AZURE_169 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Azure Kubernetes Cluster (AKS) nodes use scale sets                                                        | arm   | [AKSPoolTypeIsScaleSet.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSPoolTypeIsScaleSet.py)                                                                           |
| 151 | CKV_AZURE_171 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS cluster upgrade channel is chosen                                                                      | arm   | [AKSUpgradeChannel.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSUpgradeChannel.py)                                                                                   |
| 152 | CKV_AZURE_172 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure autorotation of Secrets Store CSI Driver secrets for AKS clusters                                          | arm   | [AkSSecretStoreRotation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AkSSecretStoreRotation.py)                                                                         |
| 153 | CKV_AZURE_173 | resource  | Microsoft.ApiManagement/service                                              | Ensure API management uses at least TLS 1.2                                                                       | arm   | [APIManagementMinTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIManagementMinTLS12.py)                                                                           |
| 154 | CKV_AZURE_174 | resource  | Microsoft.ApiManagement/service                                              | Ensure API management public access is disabled                                                                   | arm   | [APIManagementPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIManagementPublicAccess.py)                                                                   |
| 155 | CKV_AZURE_175 | resource  | Microsoft.SignalRService/webPubSub                                           | Ensure Web PubSub uses a SKU with an SLA                                                                          | arm   | [PubsubSKUSLA.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PubsubSKUSLA.py)                                                                                             |
| 156 | CKV_AZURE_176 | resource  | Microsoft.SignalRService/webPubSub                                           | Ensure Web PubSub uses managed identities to access Azure resources                                               | arm   | [PubsubSpecifyIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PubsubSpecifyIdentity.py)                                                                           |
| 157 | CKV_AZURE_177 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure Windows VM enables automatic updates                                                                       | arm   | [WinVMAutomaticUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMAutomaticUpdates.py)                                                                           |
| 158 | CKV_AZURE_177 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Windows VM enables automatic updates                                                                       | arm   | [WinVMAutomaticUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMAutomaticUpdates.py)                                                                           |
| 159 | CKV_AZURE_178 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure linux VM enables SSH with keys for secure communication                                                    | arm   | [LinuxVMUsesSSH.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/LinuxVMUsesSSH.py)                                                                                         |
| 160 | CKV_AZURE_178 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure linux VM enables SSH with keys for secure communication                                                    | arm   | [LinuxVMUsesSSH.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/LinuxVMUsesSSH.py)                                                                                         |
| 161 | CKV_AZURE_182 | resource  | Microsoft.Network/networkInterfaces                                          | Ensure that VNET has at least 2 connected DNS Endpoints                                                           | arm   | [VnetSingleDNSServer.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetSingleDNSServer.py)                                                                               |
| 162 | CKV_AZURE_182 | resource  | Microsoft.Network/virtualNetworks                                            | Ensure that VNET has at least 2 connected DNS Endpoints                                                           | arm   | [VnetSingleDNSServer.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetSingleDNSServer.py)                                                                               |
| 163 | CKV_AZURE_183 | resource  | Microsoft.Network/virtualNetworks                                            | Ensure that VNET uses local DNS addresses                                                                         | arm   | [VnetLocalDNS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetLocalDNS.py)                                                                                             |
| 164 | CKV_AZURE_189 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that Azure Key Vault disables public network access                                                        | arm   | [KeyVaultDisablesPublicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultDisablesPublicNetworkAccess.py)                                               |
| 165 | CKV_AZURE_191 | resource  | Microsoft.EventGrid/topics                                                   | Ensure that Managed identity provider is enabled for Azure Event Grid Topic                                       | arm   | [EventgridTopicIdentityProviderEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicIdentityProviderEnabled.py)                                           |
| 166 | CKV_AZURE_192 | resource  | Microsoft.EventGrid/topics                                                   | Ensure that Azure Event Grid Topic local Authentication is disabled                                               | arm   | [EventgridTopicLocalAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicLocalAuthentication.py)                                                   |
| 167 | CKV_AZURE_193 | resource  | Microsoft.EventGrid/topics                                                   | Ensure public network access is disabled for Azure Event Grid Topic                                               | arm   | [EventgridTopicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicNetworkAccess.py)                                                               |
| 168 | CKV_AZURE_206 | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that Storage Accounts use replication                                                                      | arm   | [StorageAccountsUseReplication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountsUseReplication.py)                                                           |
| 169 | CKV_AZURE_208 | resource  | Microsoft.Search/searchServices                                              | Ensure that Azure Cognitive Search maintains SLA for index updates                                                | arm   | [AzureSearchSLAIndex.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSearchSLAIndex.py)                                                                               |
| 170 | CKV_AZURE_209 | resource  | Microsoft.Search/searchServices                                              | Ensure that Azure Cognitive Search maintains SLA for search index queries                                         | arm   | [AzureSearchSLAQueryUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSearchSLAQueryUpdates.py)                                                                 |
| 171 | CKV_AZURE_212 | resource  | Microsoft.Web/sites                                                          | Ensure App Service has a minimum number of instances for failover                                                 | arm   | [AppServiceInstanceMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceInstanceMinimum.py)                                                                   |
| 172 | CKV_AZURE_212 | resource  | Microsoft.Web/sites/slots                                                    | Ensure App Service has a minimum number of instances for failover                                                 | arm   | [AppServiceInstanceMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceInstanceMinimum.py)                                                                   |
| 173 | CKV_AZURE_213 | resource  | Microsoft.Web/sites                                                          | Ensure that App Service configures health check                                                                   | arm   | [AppServiceSetHealthCheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSetHealthCheck.py)                                                                     |
| 174 | CKV_AZURE_213 | resource  | Microsoft.Web/sites/slots                                                    | Ensure that App Service configures health check                                                                   | arm   | [AppServiceSetHealthCheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSetHealthCheck.py)                                                                     |
| 175 | CKV_AZURE_216 | resource  | Microsoft.Network/azureFirewalls                                             | Ensure DenyIntelMode is set to Deny for Azure Firewalls                                                           | arm   | [AzureFirewallDenyThreatIntelMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureFirewallDenyThreatIntelMode.py)                                                     |
| 176 | CKV_AZURE_218 | resource  | Microsoft.Network/applicationGateways                                        | Ensure Application Gateway defines secure protocols for in transit communication                                  | arm   | [AppGWDefinesSecureProtocols.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppGWDefinesSecureProtocols.py)                                                               |
| 177 | CKV_AZURE_222 | resource  | Microsoft.Web/sites                                                          | Ensure that Azure Web App public network access is disabled                                                       | arm   | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 178 | CKV_AZURE_222 | resource  | Microsoft.Web/sites/config                                                   | Ensure that Azure Web App public network access is disabled                                                       | arm   | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 179 | CKV_AZURE_222 | resource  | Microsoft.Web/sites/slots                                                    | Ensure that Azure Web App public network access is disabled                                                       | arm   | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 180 | CKV_AZURE_223 | resource  | Microsoft.EventHub/namespaces                                                | Ensure Event Hub Namespace uses at least TLS 1.2                                                                  | arm   | [EventHubNamespaceMinTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventHubNamespaceMinTLS12.py)                                                                   |
| 181 | CKV_AZURE_225 | resource  | Microsoft.Web/serverfarms                                                    | Ensure the App Service Plan is zone redundant                                                                     | arm   | [AppServicePlanZoneRedundant.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePlanZoneRedundant.py)                                                               |
| 182 | CKV_AZURE_226 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure ephemeral disks are used for OS disks                                                                      | arm   | [AKSEphemeralOSDisks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEphemeralOSDisks.py)                                                                               |
| 183 | CKV_AZURE_227 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure that the AKS cluster encrypt temp disks, caches, and data flows between Compute and Storage resources      | arm   | [AKSEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEncryptionAtHostEnabled.py)                                                                 |
| 184 | CKV_AZURE_227 | resource  | Microsoft.ContainerService/managedClusters/agentPools                        | Ensure that the AKS cluster encrypt temp disks, caches, and data flows between Compute and Storage resources      | arm   | [AKSEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEncryptionAtHostEnabled.py)                                                                 |
| 185 | CKV_AZURE_229 | resource  | Microsoft.Sql/servers/databases                                              | Ensure the Azure SQL Database Namespace is zone redundant                                                         | arm   | [SQLDatabaseZoneRedundant.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLDatabaseZoneRedundant.py)                                                                     |
| 186 | CKV_AZURE_233 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure Azure Container Registry (ACR) is zone redundant                                                           | arm   | [ACREnableZoneRedundancy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableZoneRedundancy.py)                                                                       |
| 187 | CKV_AZURE_233 | resource  | Microsoft.ContainerRegistry/registries/replications                          | Ensure Azure Container Registry (ACR) is zone redundant                                                           | arm   | [ACREnableZoneRedundancy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableZoneRedundancy.py)                                                                       |
| 188 | CKV_AZURE_236 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that Cognitive Services accounts disable local authentication                                              | arm   | [CognitiveServicesEnableLocalAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesEnableLocalAuth.py)                                                     |
| 189 | CKV_AZURE_238 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that all Azure Cognitive Services accounts are configured with a managed identity                          | arm   | [CognitiveServicesConfigureIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesConfigureIdentity.py)                                                 |
| 190 | CKV_AZURE_239 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure Azure Synapse Workspace administrator login password is not exposed                                        | arm   | [SynapseWorkspaceAdministratorLoginPasswordHidden.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceAdministratorLoginPasswordHidden.py)                     |
| 191 | CKV_AZURE_240 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure Azure Synapse Workspace is encrypted with a CMK                                                            | arm   | [SynapseWorkspaceCMKEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceCMKEncryption.py)                                                           |
| 192 | CKV_AZURE_242 | resource  | Microsoft.Synapse/workspaces/bigDataPools                                    | Ensure isolated compute is enabled for Synapse Spark pools                                                        | arm   | [AzureSparkPoolIsolatedComputeEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSparkPoolIsolatedComputeEnabled.py)                                             |
| 193 | CKV_AZURE_243 | resource  | Microsoft.MachineLearningServices/workspaces                                 | Ensure Azure Machine learning workspace is configured with private endpoint                                       | arm   | [AzureMLWorkspacePrivateEndpoint.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureMLWorkspacePrivateEndpoint.py)                                                       |
| 194 | CKV_AZURE_248 | resource  | Microsoft.Batch/batchAccounts                                                | Ensure that if Azure Batch account public network access in case 'enabled' then its account access must be 'deny' | arm   | [AzureBatchAccountEndpointAccessDefaultAction.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureBatchAccountEndpointAccessDefaultAction.py)                             |
| 195 | CKV2_AZURE_19 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Azure Synapse workspaces have no IP firewall rules attached                                           | arm   | [AzureSynapseWorkspacesHaveNoIPFirewallRulesAttached.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSynapseWorkspacesHaveNoIPFirewallRulesAttached.py)               |
| 196 | CKV2_AZURE_23 | resource  | Microsoft.AppPlatform/Spring                                                 | Ensure Azure spring cloud is configured with Virtual network (Vnet)                                               | arm   | [AzureSpringCloudConfigWithVnet.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/AzureSpringCloudConfigWithVnet.yaml)                                                 |
| 197 | CKV2_AZURE_27 | resource  | Microsoft.Sql/servers                                                        | Ensure Azure AD authentication is enabled for Azure SQL (MSSQL)                                                   | arm   | [SQLServerUsesADAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerUsesADAuth.py)                                                                               |
| 198 | CKV2_AZURE_46 | resource  | Microsoft.Synapse/workspaces/vulnerabilityAssessments                        | Ensure that Azure Synapse Workspace vulnerability assessment is enabled                                           | arm   | [AzureSynapseWorkspaceVAisEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSynapseWorkspaceVAisEnabled.py)                                                     |
| 199 | CKV2_AZURE_48 | resource  | Microsoft.Databricks/workspaces                                              | Ensure that Databricks Workspaces enables customer-managed key for root DBFS encryption                           | arm   | [DatabricksWorkspaceDBFSRootEncryptedWithCustomerManagedKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DatabricksWorkspaceDBFSRootEncryptedWithCustomerManagedKey.py) |
| 200 | CKV2_AZURE_49 | resource  | Microsoft.MachineLearningServices/workspaces                                 | Ensure that Azure Machine learning workspace is not configured with overly permissive network access              | arm   | [AzureMLWorkspacePublicNetwork.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/AzureMLWorkspacePublicNetwork.yaml)                                                   |
| 201 | CKV2_AZURE_51 | resource  | Microsoft.Sql/servers/securityAlertPolicies                                  | Ensure Synapse SQL Pool has a security alert policy                                                               | arm   | [SynapseSQLPoolHasSecurityAlertPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseSQLPoolHasSecurityAlertPolicy.yaml)                                     |
| 202 | CKV2_AZURE_51 | resource  | Microsoft.Synapse/workspaces/sqlPools                                        | Ensure Synapse SQL Pool has a security alert policy                                                               | arm   | [SynapseSQLPoolHasSecurityAlertPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseSQLPoolHasSecurityAlertPolicy.yaml)                                     |
| 203 | CKV2_AZURE_52 | resource  | Microsoft.Sql/servers/securityAlertPolicies                                  | Ensure Synapse SQL Pool has vulnerability assessment attached                                                     | arm   | [SynapseSQLPoolHasVulnerabilityAssessment.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseSQLPoolHasVulnerabilityAssessment.yaml)                             |
| 204 | CKV2_AZURE_52 | resource  | Microsoft.Sql/servers/vulnerabilityAssessments                               | Ensure Synapse SQL Pool has vulnerability assessment attached                                                     | arm   | [SynapseSQLPoolHasVulnerabilityAssessment.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseSQLPoolHasVulnerabilityAssessment.yaml)                             |
| 205 | CKV2_AZURE_52 | resource  | Microsoft.Synapse/workspaces/sqlPools                                        | Ensure Synapse SQL Pool has vulnerability assessment attached                                                     | arm   | [SynapseSQLPoolHasVulnerabilityAssessment.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseSQLPoolHasVulnerabilityAssessment.yaml)                             |
| 206 | CKV2_AZURE_53 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure Azure Synapse Workspace has extended audit logs                                                            | arm   | [SynapseWorkspaceHasExtendedAuditLogs.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseWorkspaceHasExtendedAuditLogs.yaml)                                     |
| 207 | CKV2_AZURE_53 | resource  | Microsoft.Synapse/workspaces/extendedAuditingPolicies                        | Ensure Azure Synapse Workspace has extended audit logs                                                            | arm   | [SynapseWorkspaceHasExtendedAuditLogs.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseWorkspaceHasExtendedAuditLogs.yaml)                                     |
| 208 | CKV2_AZURE_54 | resource  | Microsoft.Synapse/workspaces/sqlPools                                        | Ensure log monitoring is enabled for Synapse SQL Pool                                                             | arm   | [SynapseLogMonitoringEnabledForSQLPool.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseLogMonitoringEnabledForSQLPool.yaml)                                   |
| 209 | CKV2_AZURE_54 | resource  | Microsoft.Synapse/workspaces/sqlPools/auditingSettings                       | Ensure log monitoring is enabled for Synapse SQL Pool                                                             | arm   | [SynapseLogMonitoringEnabledForSQLPool.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/graph_checks/SynapseLogMonitoringEnabledForSQLPool.yaml)                                   |


---


